#ifndef CE2_TCT_ECC_2_h
#define CE2_TCT_ECC_2_h

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CE2_TST_Config.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Tues Mar 13 12:00:00 2007
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief A tests for ECC
*
*  \version CE2_TCT_ECC_2.h#1:incl:1
*  \author Yermalayeu Ihar
*  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
*           All Rights reserved
*/
/************************ Defines ******************************/

#define TST_MAX_ECC_KEY_SIZE_BYTES 255
#define TST_NAME_STRING_LEN 150
#define TST_MAX_DATA_VEC_SIZE_IN_BYTS 1536

/************************ Enums ********************************/
/************************ Typedefs  ****************************/
/************************ Structs  ******************************/

typedef struct TST_ECC_SignVerifyTestDataStruct{	
  char					    TST_Name[TST_NAME_STRING_LEN];
  CE2_ECPKI_DomainID_t		TST_CE2_ECPKI_DomainID;
  CE2_ECPKI_HASH_OpMode_t    TST_HashMode;
  DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];	
  DxUint32_t                  TST_input_dataSize;
  DxUint8_t                   TST_ExternalPublKey[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPublKeySize;
  DxUint8_t                   TST_ExternalPrivKey[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPrivKeySize;
  DxUint8_t                   TST_output_signiture[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint32_t                  TST_SignitureSize;
} TST_ECC_SignVerifyTestDataStruct;

typedef struct TST_ECC_DH_TestDataStruct{	
  char					    TST_Name[TST_NAME_STRING_LEN];
  CE2_ECPKI_DomainID_t		TST_CE2_ECPKI_DomainID;
  DxUint8_t                   TST_ExternalPublKey1[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPublKey1Size;
  DxUint8_t                   TST_ExternalPrivKey1[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPrivKey1Size;
  DxUint8_t                   TST_ExternalPublKey2[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPublKey2Size;
  DxUint8_t                   TST_ExternalPrivKey2[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPrivKey2Size;
} TST_ECC_DH_TestDataStruct;

typedef struct TST_ECC_EncDecTestDataStruct{	
  char					    TST_Name[TST_NAME_STRING_LEN];
  CE2_ECPKI_DomainID_t		TST_CE2_ECPKI_DomainID;
  DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];	
  DxUint32_t                  TST_input_dataSize;
  DxUint8_t                   TST_ExternalPublKey[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPublKeySize;
  DxUint8_t                   TST_ExternalPrivKey[TST_MAX_ECC_KEY_SIZE_BYTES];
  DxUint32_t                  TST_ExternalPrivKeySize;
  DxUint8_t                   TST_output_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxInt32_t                   TST_output_dataSize;
  DxUint8_t                   TST_Decrypted_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint32_t                  TST_Decrypted_dataSize;
} TST_ECC_EncDecTestDataStruct;

/************************ Public Variables **********************/

extern TST_ECC_SignVerifyTestDataStruct  TST_ECC_Acceptance_ECDSA_SignVerify_TestData[];
extern TST_ECC_DH_TestDataStruct         TST_ECC_Acceptance_DH_TestData[];
extern TST_ECC_EncDecTestDataStruct      TST_ECC_Acceptance_ElGamal_EncDec_TestData[];
extern int TST_NumberOf_ECC_SignVerifyAcceptanceTests;
extern int TST_NumberOf_ECC_DHAcceptanceTests;
extern int TST_NumberOf_ECC_ElGamalAcceptanceTests;

/************************ Public Functions **********************/

#include "CE2_TST_Config.h"

/*********************************************************
* Function Name:                                                           
*  CE2_ATP_TST_ECC_Acceptance_ECDSA_NonIntegratedSignVerify        
* 
* Description:                                                                 
*  This function Is a Acceptance test for ECC ESDSA Sign & Verify                   
*  This function Signs & Verifies known vectors 
* Algorithm:       
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
*  2. Call the CE2_ECDSA_SignInit to init the Sign operation
*  3. Call the CE2_ECDSA_SignUpdate - This function is called N times
*                                        (N = number of blocks in data each block is 16byte)
*  4. Call the CE2_ECDSA_SignFinish to complete the sign operation
*  5. Call the CE2_ECDSA_VerifyInit to init the verification operation
*  7. Call the CE2_ECDSA_VerifyUpdate - This function is called N times
*                                        (N = number of blocks in data each block is 16byte)
*  7.Call the CE2_ECDSA_VerifyFinish to complete the verification operation     
*
* Inputs:
*  None
*
* Outputs:
*  CE2Error_t - Function error return         
*
*******************************************************************************/    							
CE2Error_t CE2_ATP_TST_ECC_Acceptance_ECDSA_NonIntegratedSignVerify( 
  FILE *out, int TST_KeyGeneration_TestStatus);

/*********************************************************
* Function Name:                                                           
*  CE2_ATP_TST_ECC_Acceptance_ECDSA_IntegratedSignVerify        
* 
* Inputs:
*  None
*
* Outputs:
*  CE2Error_t - Function error return                                     
*                                
*
* Description:                                                                 
*  This function Is a Acceptance test for ECC ESDSA Sign & Verify                   
*  This function Signs & Verifies known vectors 
* Algorithm:       
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
*  2. Call CE2_ECDSA_Sign to perform the sign operation
*  3. Call CE2_ECDSA_Verify to perform the verification operation   
*
******************************************************************************/    
CE2Error_t CE2_ATP_TST_ECC_Acceptance_ECDSA_IntegratedSignVerify(  
  FILE *out, int TST_KeyGeneration_TestStatus);

/*********************************************************
* Function Name:                                                           
*  CE2_ATP_TST_ECC_Acceptance_DH        
* 
* Inputs:
*  None
*
* Outputs:
*  CE2Error_t - Function error return                                     
*
* Description:                                                                      
* To test the Diffie-Hellman key shared secret generation using ECC capabilities
*
* Algorithm: 
* 1.Build or generate the private and public keys for user 1 using       
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
* 2.Build or generate the private and public keys for user 2 using 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
* 3. Call CE2_ECDH_SVDP_DH  to Create a shared secret 1 for user 1 
*    using user1 private key and user 2 public key 
* 4. Call CE2_ECDH_SVDP_DH  to Create a shared secret 2 for user 2 
*    using user2 private key and user 1 public key
* 5. Compare the two secret keys - to verify they are identical
*
******************************************************************************/  
CE2Error_t CE2_ATP_TST_ECC_Acceptance_DH  (
  FILE *out,   int TST_KeyGeneration_TestStatus );

/*********************************************************
* Function Name:                                                           
*  CE2_ATP_TST_ECC_Acceptance_ElGamal_EncDec        
* 
* Inputs:
*  None
*
* Outputs:
*  CE2Error_t - Function error return                                     
*
* Description:                                                                      
* To test the El-Gamal algorithm for encryption and decryption
*
* Algorithm:      
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
* 2. Encrypt a block of data using the CE2_ECPKI_ELGAMAL_Encrypt encryption process
* 3. Decrypt a block of data using CE2_ECPKI_ELGAMAL_Decrypt decryption process 
* 4. Compare the decrypted data to the original data
*
******************************************************************************/   
CE2Error_t CE2_ATP_TST_ECC_Acceptance_ElGamal_EncDec  (FILE *out,  int TST_KeyGeneration_TestStatus );

/*********************************************************
* Function Name:                                                           
*  CE2_ATP_TST_ECC_Acceptance_ImportExportKeyPair        
* 
* Inputs:
*  None
*
* Outputs:
*  CE2Error_t - Function error return                                     
*
* Description:                                                                      
* To test the ECC export public key functionality
*
* Algorithm:      
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
*  2.	Export the public key using CE2_ECPKI_ExportPublKey
*  3.	Re-build the exported key using CE2_ECPKI_Build_PubKey
*  4.	Sign a massage using the exported public key using CE2_ECDSA_Sign to perform the sign operation
*  5.	Verify the massage using the appropriate public key using CE2_ECDSA_Verify
*      to perform the verification operation
*
******************************************************************************/  
CE2Error_t CE2_ATP_TST_ECC_Acceptance_ImportExportKeyPair(FILE *out,  int TST_KeyGeneration_TestStatus);

#endif /*CE2_TCT_ECC_2_h*/
